// DB_APIVCClientDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "DB_APIVCClientDlg.h"
#include "AddAccessLevel.h"
#include "EditAccessLevel.h"
#include "DeleteAccessLevel.h"
#include "ConfigureEntranceAccess.h"
#include "ConfigureAreaAccess.h"
#include "login.h"
#include "AddCard.h"
#include "EditCard.h"
#include "DeleteCard.h"
#include "AddCH.h"
#include "EditCH.h"
#include "DeleteCH.h"
#include "ADVList.h"
#include "GetCardsByCH.h"
#include "GetAccounts.h"
#include "GetCardHolders.h"
#include "SetAccountExtRefID.h"
#include "SetCHExtRefId.h"
#include "ConfigureOutputTZ.h"
#include "ConfigureGroupTZ.h"
#include "AddTimeZone.h"
#include "EditTimeZone.h"
#include "DeleteTimeZone.h"
#include "ConfigureTimeZoneRange.h"
#include "DeleteTimeZoneRange.h"
#include "ConfigurePanelTimeZone.h"
#include "AddMasterHoliday.h"
#include "EditMasterHoliday.h"
#include "DeleteMasterHoliday.h"
#include "AddHolidayGroup.h"
#include "EditHolidayGroup.h"
#include "DeleteHolidayGroup.h"
#include "GetAllNoteFields.h"
#include "ConfigurePanelHG.h"
#include "CreateALTZ.h"
#include "GetAccessTree.h"
#include "CardHolderSearch.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDB_APIVCClientDlg dialog

CDB_APIVCClientDlg::CDB_APIVCClientDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDB_APIVCClientDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDB_APIVCClientDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CDB_APIVCClientDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDB_APIVCClientDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDB_APIVCClientDlg, CDialog)
	//{{AFX_MSG_MAP(CDB_APIVCClientDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_COMMAND(ID_ACCESSLEVELS_ADDACCESSLEVEL, OnAddaccesslevel)
	ON_COMMAND(ID_ACCESSLEVELS_EDIT, OnEditaccesslevel)
	ON_COMMAND(ID_ACCESSLEVELS_DELETE, OnDeleteaccesslevel)
	ON_COMMAND(ID_ACCESSLEVELS_COFIGUREENTRANCE, OnConfigureEntranceAccess)
	ON_COMMAND(ID_ACCESSLEVELS_CONFIGUREAREA, OnConfigureAreaAccess)
	ON_COMMAND(ID_FILE_LOGIN, OnLogin)
	ON_COMMAND(ID_HELP_ABOUT, OnAbout)
	ON_COMMAND(ID_CARD_ADD, OnCardAdd)
	ON_COMMAND(ID_CARD_EDIT, OnCardEdit)
	ON_COMMAND(ID_CARD_DELETE, OnCardDelete)
	ON_COMMAND(ID_CARDHOLDER_ADD, OnCardholderAdd)
	ON_COMMAND(ID_CARDHOLDER_EDIT, OnCardholderEdit)
	ON_COMMAND(ID_CARDHOLDER_DELETE, OnCardholderDelete)
	ON_COMMAND(ID_FILE_ACCESSTYPE, OnFileAccesstype)
	ON_COMMAND(ID_FILE_LOGOUT, OnFileLogout)
	ON_COMMAND(ID_FILE_MAXCARDLENGTH, OnFileMaxcardlength)
	ON_COMMAND(ID_FILE_ISCARDNUMERIC, OnFileIscardnumeric)
	//ON_COMMAND(ID_FILE_GETWPCSDSN, OnFileGetwpcsdsn)
	ON_COMMAND(ID_FILE_GETADVDETAILS, OnFileGetadvdetails)
	ON_COMMAND(ID_CARDHOLDER_GETCARDS, OnCardholderGetcards)
	ON_COMMAND(ID_ACCOUNT_GETACCOUNTS, OnAccountGetaccounts)
	ON_COMMAND(ID_CARDHOLDER_GETCARDHOLDERS, OnCardholderGetcardholders)
	ON_COMMAND(ID_CONFIGURETIMEZONE_CONFIGUREGROUP, OnConfiguretimezoneConfiguregroup)
	ON_COMMAND(ID_CONFIGURETIMEZONE_CONFIGUREOUTPUT, OnConfiguretimezoneConfigureoutput)
	ON_COMMAND(ID_TIMEZONE_ADDTIMEZONE, OnTimezoneAddtimezone)
	ON_COMMAND(ID_TIMEZONE_EDITTIMEZONE, OnTimezoneEdittimezone)
	ON_COMMAND(ID_TIMEZONE_DELETETIMEZONE, OnTimezoneDeletetimezone)
	ON_COMMAND(ID_TIMEZONE_CONFIGURETIMEZONERANGE, OnTimezoneConfiguretimezonerange)
	ON_COMMAND(ID_TIMEZONE_DELETETIMEZONERANGE, OnTimezoneDeletetimezonerange)
	ON_COMMAND(ID_CONFIGURETIMEZONE_CONFIGUREPANELTIMEZONE, OnConfiguretimezoneConfigurepaneltimezone)
	ON_COMMAND(ID_HOLIDAYGROUP_ADDHOLIDAYGROUP, OnHolidaygroupAddholidaygroup)
	ON_COMMAND(ID_HOLIDAYGROUP_EDITHOLIDAYGROUP, OnHolidaygroupEditholidaygroup)
	ON_COMMAND(ID_HOLIDAYGROUP_DELETEHOLIDAYGROUP, OnHolidaygroupDeleteholidaygroup)
	ON_COMMAND(ID_HOLIDAY_ADDHOLIDAY, OnHolidayAddHoliday)
	ON_COMMAND(ID_HOLIDAY_EDITHOLIDAY, OnHolidayEditHoliday)
	ON_COMMAND(ID_HOLIDAY_DELETEHOLIDAY, OnHolidayDeleteHoliday)
	ON_COMMAND(ID_CARDHOLDER_NOTEFIELDDETAILS, OnCardholderNotefielddetails)
	ON_COMMAND(ID_ACCOUNT_GETALLACCOUNTDETAILS, OnAccountGetaccounts)
	ON_COMMAND(ID_HOLIDAYGROUP_CONFIGUREPANELHG, OnConfigurePanelHG)
	ON_COMMAND(ID_ACCOUNT_CREATEALTZ, OnCreateALTZ)
	ON_COMMAND(ID_ACCESSLEVELS_GETACCESSTREE, OnGetAccessTree)
	ON_COMMAND(ID_CARDHOLDER_SEARCH, OnSearchCardHolders)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDB_APIVCClientDlg message handlers

BOOL CDB_APIVCClientDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	//create instance for Application class;
	//CoInitialize(0);
	OleInitialize(0);
	{
		pApp.CreateInstance(__uuidof(Application));
	}
	//Bharani Jul-08-08
	//COleMessageFilter *pFilter;
	//pFilter = AfxOleGetMessageFilter();
	//pFilter->SetMessagePendingDelay(20000);
	AfxOleGetMessageFilter()->SetMessagePendingDelay(20000);
	AfxOleGetMessageFilter()->EnableNotRespondingDialog(FALSE);
	AfxOleGetMessageFilter()->EnableBusyDialog(FALSE);  
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDB_APIVCClientDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDB_APIVCClientDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDB_APIVCClientDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CDB_APIVCClientDlg::OnAddaccesslevel() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CAddAccessLevel obj(pApp);
	obj.DoModal();	
	
}

void CDB_APIVCClientDlg::OnEditaccesslevel() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
		CEditAccessLevel obj(pApp);
		obj.DoModal();	
	
}

void CDB_APIVCClientDlg::OnDeleteaccesslevel() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
		CDeleteAccessLevel obj(pApp);
		obj.DoModal();	
	
}
void CDB_APIVCClientDlg::OnConfigureEntranceAccess() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
		CConfigureEntranceAccess obj(pApp);
		obj.DoModal();	
}


void CDB_APIVCClientDlg::OnConfigureAreaAccess() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}		
		CConfigureAreaAccess obj(pApp);
		obj.DoModal();	
}

void CDB_APIVCClientDlg::OnLogin() 
{
	CLogin obj(pApp);
	obj.DoModal();
}
void CDB_APIVCClientDlg::OnAbout()
{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
}

void CDB_APIVCClientDlg::OnCardAdd() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CAddCard obj(pApp);
	obj.DoModal();
	
}

void CDB_APIVCClientDlg::OnCardEdit() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CEditCard obj(pApp);
	obj.DoModal();
	
}

void CDB_APIVCClientDlg::OnCardDelete() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CDeleteCard obj(pApp);
	obj.DoModal();
	
}

void CDB_APIVCClientDlg::OnCardholderAdd() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CAddCH obj(pApp);
	obj.DoModal();
	
}

void CDB_APIVCClientDlg::OnCardholderEdit() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CEditCH obj(pApp);
	obj.DoModal();
	
}

void CDB_APIVCClientDlg::OnCardholderDelete() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CDeleteCH obj(pApp);
	obj.DoModal();
	
}

void CDB_APIVCClientDlg::OnFileAccesstype() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	try
	{
		int ntype;
		pApp->GetAccessLevelType(&ntype); //get the access level type
		VARIANT_BOOL bAccessTypeMulExpiry = FALSE;
		pApp->GetAccessLevelMultipleTypeWithExpiry(&bAccessTypeMulExpiry);  //WPACT-5664-- DB API Returns wrong Access level value when the Access level is set to the "Multiple with Expiration Date"

		if(ntype == 0 )
			AfxMessageBox(_T("PRECISION"));
		if (ntype == 1)
		{
			if(bAccessTypeMulExpiry)
				AfxMessageBox(_T("MULTIPLE WITH EXPIRATION DATE"));  //WPACT-5664-- DB API Returns wrong Access level value when the Access level is set to the "Multiple with Expiration Date"
			else
			AfxMessageBox(_T("MULTIPLE"));
		}
	}
	catch (_com_error &e)
	{
		BSTR bstrError = e.Description();
		
	}
	/*long lstatus;
	BSTR bstrextRefID = SysAllocString(L"AccountID05");
	//pApp->SetExtRefIDByCHID(2,bstrextRefID,&lstatus);
	 //pApp->SetExtRefIDByAcctID(5,bstrextRefID,&lstatus);*/

}

void CDB_APIVCClientDlg::OnFileLogout() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	pApp->Logout();
	// Fix for TT563 - Couninitialize not needed when client using smart pointer
	//CoUninitialize();
	
}

void CDB_APIVCClientDlg::OnFileMaxcardlength() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}	
	try
	{
		int nCardLen;
		pApp->GetMaxCardNumberLength(&nCardLen); // get the card length 
		CString str;
		str.Format(_T("%d"),nCardLen);
		if (nCardLen >0)
		AfxMessageBox(str);
	}
	catch (_com_error &e)
	{
		BSTR bstrError = e.Description();
		
	}
}

void CDB_APIVCClientDlg::OnFileIscardnumeric() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	try
	{
		VARIANT_BOOL bIsCardNumeric;
		pApp->GetCardNumeric(&bIsCardNumeric); // check the card number type
		
		if(bIsCardNumeric == 0 )
			AfxMessageBox(_T("FALSE"));
		if (bIsCardNumeric == 1)
			AfxMessageBox(_T("TRUE"));
	}
	catch (_com_error &e)
	{
		BSTR bstrError = e.Description();
		
	}
	
}

/*
void CDB_APIVCClientDlg::OnFileGetwpcsdsn() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	BSTR bstrDSN;
	pApp->GetWPDSN(&bstrDSN);
	CString sDSN= CString(bstrDSN);
	AfxMessageBox(sDSN);
}
*/

void CDB_APIVCClientDlg::OnFileGetadvdetails() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CADVList obj(pApp);
	obj.DoModal();
}


void CDB_APIVCClientDlg::OnCardholderGetcards() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}	
	CGetCardsByCH obj(pApp);
	obj.DoModal();
	
}

void CDB_APIVCClientDlg::OnAccountGetaccounts() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CGetAccounts obj(pApp);
	obj.DoModal();
	
}

void CDB_APIVCClientDlg::OnCardholderGetcardholders() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CGetCardHolders obj(pApp);
	obj.DoModal();
	
}


void CDB_APIVCClientDlg::OnConfiguretimezoneConfiguregroup() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CConfigureGroupTZ obj(pApp);
	obj.DoModal();
}

void CDB_APIVCClientDlg::OnConfiguretimezoneConfigureoutput() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CConfigureOutputTZ obj(pApp);
	obj.DoModal();

	
}

void CDB_APIVCClientDlg::OnTimezoneAddtimezone() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CAddTimeZone obj(pApp);
	obj.DoModal();	
}

void CDB_APIVCClientDlg::OnTimezoneEdittimezone() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CEditTimeZone obj(pApp);
	obj.DoModal();
	
}

void CDB_APIVCClientDlg::OnTimezoneDeletetimezone() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CDeleteTimeZone obj(pApp);
	obj.DoModal();
}

void CDB_APIVCClientDlg::OnTimezoneConfiguretimezonerange() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CConfigureTimeZoneRange obj(pApp);
	obj.DoModal();
}

void CDB_APIVCClientDlg::OnTimezoneDeletetimezonerange() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	DeleteTimeZoneRange obj(pApp);
	obj.DoModal();
	
}

void CDB_APIVCClientDlg::OnConfiguretimezoneConfigurepaneltimezone() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CConfigurePanelTimeZone obj(pApp);
	obj.DoModal();
	
}


void CDB_APIVCClientDlg::OnHolidaygroupAddholidaygroup() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CAddHolidayGroup obj(pApp);
	obj.DoModal();
	
}

void CDB_APIVCClientDlg::OnHolidaygroupEditholidaygroup() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CEditHolidayGroup obj(pApp);
	obj.DoModal();
	
}

void CDB_APIVCClientDlg::OnHolidaygroupDeleteholidaygroup() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CDeleteHolidayGroup obj(pApp);
	obj.DoModal();
	
}



void CDB_APIVCClientDlg::OnHolidayAddHoliday() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CAddMasterHoliday obj(pApp, FALSE);
	obj.DoModal();
}

void CDB_APIVCClientDlg::OnHolidayEditHoliday() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CEditMasterHoliday obj(pApp, FALSE);
	obj.DoModal();
}

void CDB_APIVCClientDlg::OnHolidayDeleteHoliday() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CDeleteMasterHoliday obj(pApp, FALSE);
	obj.DoModal();
}

void CDB_APIVCClientDlg::OnCardholderNotefielddetails() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CGetAllNoteFields obj(pApp);
	obj.DoModal();
}

void CDB_APIVCClientDlg::OnConfigurePanelHG() 
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CConfigurePanelHG obj(pApp);
	obj.DoModal();
}


void CDB_APIVCClientDlg::OnCreateALTZ()
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CCreateALTZ obj(pApp);
	obj.DoModal();
}

void CDB_APIVCClientDlg::OnClose() 
{
	if(pApp)
	{
		long lConnected;
		pApp->IsConnected(&lConnected);
		if(lConnected)
			pApp->Logout();
	}
	pApp = NULL;
	CDialog::OnClose();
}

BOOL CDB_APIVCClientDlg::DestroyWindow() 
{
	if(pApp)
	{
		long lConnected;
		pApp->IsConnected(&lConnected);
		if(lConnected)
			pApp->Logout();
	}
	pApp = NULL;
	return CDialog::DestroyWindow();
}


void CDB_APIVCClientDlg::OnGetAccessTree()
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CGetAccessTree obj(pApp);
	obj.DoModal();
}

void CDB_APIVCClientDlg::OnSearchCardHolders()
{
	long lConnected;
	pApp->IsConnected(&lConnected);

	if(!lConnected)
	{
		AfxMessageBox(_T("Not Connected to the WIN-PAK DB Server\nPlease Login First"));
		return;
	}
	CCardHolderSearch obj(pApp);
	obj.DoModal();
}